# -*- encoding: UTF-8 -*-
r"""
# format: USD 20.25 -> twenty dollars and twenty-five cents
__numbertext__
^0 zero
1 one
2 two
3 three
4 four
5 five
6 six
7 seven
8 eight
9 nine
10 ten
11 eleven
12 twelve
13 thirteen
15 fifteen
18 eighteen
1(\d) $1teen
20 twenty
2(\d) twenty-$1
30 thirty
3(\d) thirty-$1
40 forty
4(\d) forty-$1
50 fifty
5(\d) fifty-$1
80 eighty
8(\d) eighty-$1
(\d)0 $1ty
(\d)(\d) $1ty-$2

# separator function
:0+			# one million
:0*\d?\d " and"		# one million and twenty-two
:\d+ ,			# one million, one thousand

(\d)(\d\d) $1 hundred$(:\2) $2
(\d{1,2})([1-9]\d\d) $1 thousand $2	# ten thousand two hundred
(\d{1,3})(\d{3}) $1 thousand$(:\2) $2	# one hundred thousand, two hundred
(\d{1,3})(\d{6}) $1 million$(:\2) $2
(\d{1,3})(\d{9}) $1 billion$(:\2) $2
(\d{1,3})(\d{12}) $1 trillion$(:\2) $2
(\d{1,3})(\d{15}) $1 quadrillion$(:\2) $2
(\d{1,3})(\d{18}) $1 quintillion$(:\2) $2
(\d{1,3})(\d{21}) $1 sextillion$(:\2) $2
(\d{1,3})(\d{24}) $1 septillion$(:\2) $2

# negative number

[-−](\d+) negative |$1

# decimals

0[.,] point
([-−]?\d+)[.,] $1| point
([-−]?\d+[.,]\d*)(\d) $1| |$2

# currency

# unit/subunit singular/plural

us:([^,]*),([^,]*),([^,]*),([^,]*) \1
up:([^,]*),([^,]*),([^,]*),([^,]*) \2
ss:([^,]*),([^,]*),([^,]*),([^,]*) \3
sp:([^,]*),([^,]*),([^,]*),([^,]*) \4

AUD:(\D+) $(\1: Australian dollar, Australian dollars, cent, cents)
BGN:(\D+) $(\1: lev, leva, stotinka, stotinki)
BWP:(\D+) $(\1: pula, pula, thebe, thebe)
CAD:(\D+) $(\1: Canadian dollar, Canadian dollars, cent, cents)
CHF:(\D+) $(\1: Swiss franc, Swiss francs, centime, centimes)
CNY:(\D+) $(\1: Chinese yuan, Chinese yuan, fen, fen)
CZK:(\D+) $(\1: Czech koruna, Czech koruny, halér, halére)
EEK:(\D+) $(\1: kroon, kroonid,	sent, senti)
EUR:(\D+) $(\1: euro, euro, cent, cents)
GBP:(\D+) $(\1: pound sterling, pounds sterling, penny, pence)
GHS:(\D+) $(\1: Ghana cedi, Ghana cedis, pesewa, pesewas)
GMD:(\D+) $(\1: dalasi, dalasi, butut, bututs)
HKD:(\D+) $(\1: Hong Kong dollar, Hong Kong dollars, cent, cents)
HRK:(\D+) $(\1: kuna, kuna, lipa, lipa)
HUF:(\D+) $(\1: forint, forint, fillér, fillér)
INR:(\D+) $(\1: Indian rupee, Indian rupees, paisa, paise)
JMD:(\D+) $(\1: Jamaica dollar, Jamaica dollars, cent, cents)
JPY:(\D+) $(\1: Japanese yen, Japanese yen, sen, sen)
KES:(\D+) $(\1: Kenyan shilling, Kenyan shillings, cent, cents)
LRD:(\D+) $(\1: Liberian dollar, Liberian dollars, cent, cents)
LSL:(\D+) $(\1: loti, maloti, sente, lisente)
LTL:(\D+) $(\1: litas, litai, centas, centai)
LVL:(\D+) $(\1: lats, lati, santims, santimi)
MGA:(\D+) $(\1: ariary, ariaries, iraimbilanja, iraimbilanja)
MUR:(\D+) $(\1: Mauritian rupee, Mauritian rupees, cent, cents)
MXN:(\D+) $(\1: Mexican peso, Mexican pesos, centavo, centavos)
MWK:(\D+) $(\1: Malawian kwacha, Malawian kwacha, tambala, tambala)
NAD:(\D+) $(\1: Namibian dollar, Namibian dollars, cent, cents)
NGN:(\D+) $(\1: naira, naira, kobo, kobo)
NZD:(\D+) $(\1: New Zealand dollar, New Zealand dollars, cent, cents)
PGK:(\D+) $(\1: kina, kina, toea, toea)
PHP:(\D+) $(\1: Philippine peso, Philippine pesos, centavo, centavos)
PKR:(\D+) $(\1: Pakistani rupee, Pakistani rupees, paisa, paise)
PLN:(\D+) $(\1: zloty, zlotys, grosz, groszy)
RON:(\D+) $(\1: Romanian leu, Romanian lei, ban, bani)
RSD:(\D+) $(\1: Serbian dinar, Serbian dinars, para, para)
RUB:(\D+) $(\1: Russian ruble, Russian rubles, kopek, kopeks)
RWF:(\D+) $(\1: Rwandese franc, Rwandese francs, centime, centimes)
SDG:(\D+) $(\1: Sudanese pound, Sudanese pounds, piastre, piastres)
SGD:(\D+) $(\1: Singapore dollar, Singapore dollars, cent, cents)
SLL:(\D+) $(\1: leone, leones, cent, cents)
SZL:(\D+) $(\1: lilangeni, emalangeni, cent, cents)
THB:(\D+) $(\1: baht, baht, satang, satang)
TRY:(\D+) $(\1: Turkish lira, Turkish lira, kurus, kurus)
TTD:(\D+) $(\1: Trinidad and Tobago dollar, Trinidad and Tobago dollars, cent, cents)
TZS:(\D+) $(\1: Tanzanian shilling, Tanzanian shillings, cent, cents)
UAH:(\D+) $(\1: hryvnia, hryvnia, kopiyka, kopiyka)
UGX:(\D+) $(\1: Uganda shilling, Uganda shillings, cent, cents)
USD:(\D+) $(\1: U.S. dollar, U.S. dollars, cent, cents)
X[AO]F:(\D+) $(\1: CFA franc, CFA francs, centime, centimes)
ZAR:(\D+) $(\1: South African rand, South African rand, cent, cents)
ZMK:(\D+) $(\1: Zambian kwacha, Zambian kwacha, ngwee, ngwee)
ZWL:(\D+) $(\1: Zimbabwe dollar, Zimbabwe dollars, cent, cents)

"(JPY [-−]?\d+)[.,](\d\d)0" $1
"(JPY [-−]?\d+[.,]\d\d)(\d)" $1 $2 rin

"([A-Z]{3}) ([-−]?1)([.,]00?)?" $2 $(\1:us)
"([A-Z]{3}) ([-−]?\d+)([.,]00?)?" $2 $(\1:up)

"(CNY [-−]?\d+)[.,](\d)0?" $1 $2 jiao
"(CNY [-−]?\d+[.,]\d)(\d)" $1 $2 fen

"((MGA|MRO) [-−]?\d+)[.,]0" $1
"((MGA|MRO) [-−]?\d+)[.,]2" $1 and |$(1) $(\2:ss)
"((MGA|MRO) [-−]?\d+)[.,]4" $1 and |$(2) $(\2:sp)
"((MGA|MRO) [-−]?\d+)[.,]6" $1 and |$(3) $(\2:sp)
"((MGA|MRO) [-−]?\d+)[.,]8" $1 and |$(4) $(\2:sp)

"(([A-Z]{3}) [-−]?\d+)[.,](01)" $1 and |$(1) $(\2:ss)
"(([A-Z]{3}) [-−]?\d+)[.,](\d)" $1 and |$(\30) $(\2:sp)
"(([A-Z]{3}) [-−]?\d+)[.,](\d\d)" $1 and |$3 $(\2:sp)

# ordinal numbers

"ord ([-−]?\d+)" $(ord:|$1)

ord:(.*)one	\1first
ord:(.*)two	\1second
ord:(.*)three	\1third
ord:(.*)five	\1fifth
ord:(.*)eight	\1eighth
ord:(.*)nine	\1ninth
ord:(.*)twelve	\1twelfth
ord:(.*)y	\1ieth
"ord:(.*[^ ]) *" \1th

# ordinal abbreviation

"ord2 (.*1\d)"	\1th
"ord2 (.*1)"	\1st
"ord2 (.*2)"	\1nd
"ord2 (.*3)"	\1rd
"ord2 (.*)"	\1th

help Functions:\n ord \(ordinal numbers, eg. "first"\)\nord2 \(ordinal abbreviations, eg. "1st"\)\nExtra modules:\nen_US_2 \(subunit as decimal fraction: "USD 20.25" -> twenty and 25/100 dollars\)
"""
from __future__ import unicode_literals
