# -*- encoding: UTF-8 -*-
r"""
__numbertext__
^0 אפס
1 אחת
2 שתיים
3 שלוש
4 ארבע
5 חמש
6 שש
7 שבע
8 שמונה
9 תשע
10 עשר
12 שתים-עשרה
1(\d) $1-עשרה

20 עשרים
50 חמישים
60 שישים
80 שמונים
(\d)0 $1ים

(\d)(\d) $(\10) ו$2

# separator after 1-2 hundred(s)
hs1:20 " ו"    # מאה ועשרים
hs1:(\d\d) $(hs:\1)

# separator after 3+ hundreds
hs:0+          # מאה
hs:[01]\d " ו" # מאה ועשר
hs:\d+ " "     # מאה שלושים וחמש

1(\d\d) מאה$(hs1:\1)$1
2(\d\d) מאתיים$(hs1:\1)$1
(\d)(\d\d) $(df:\1) מאות$(hs:\2)$2

# separator after thousands+
ts:0+          # אלף
ts:0+\d\d " ו" # אלף ושלושים
ts:\d+ " "     # אלף מאה שלושים

1(\d{3}) אלף$(ts:\1)$1
2(\d{3}) אלפיים$(ts:\1)$1
([3-9]|10)(\d{3}) $(dm2:\1) אלפים$(ts:\2)$2
(\d{1,3})(\d{3}) $(m:$1) אלף$(ts:\2)$2

1(\d{6}) מיליון$(ts:\1)$1
2(\d{6}) שני מיליונים$(ts:\1)$1
([3-9]|10)(\d{6}) $(m:$1) מיליונים$(ts:\2)$2
(\d{1,3})(\d{6}) $(m:$1) מיליון$(ts:\2)$2

1(\d{9}) מיליארד$(ts:\1)$1
2(\d{9}) שני מיליארדים$(ts:\1)$1
([3-9]|10)(\d{9}) $(m:$1) מיליארדים$(ts:\2)$2
(\d{1,3})(\d{9}) $(m:$1) מיליארד$(ts:\2)$2

1(\d{12}) טריליון$(ts:\1)$1
2(\d{12}) שני טריליונים$(ts:\1)$1
([3-9]|10)(\d{12}) $(m:$1) טריליונים$(ts:\2)$2
(\d{1,3})(\d{12}) $(m:$1) טריליון$(ts:\2)$2

1(\d{15}) קוודראליון$(ts:\1)$1
2(\d{15}) שני קוודראליונים$(ts:\1)$1
([3-9]|10)(\d{15}) $(m:$1) קוודראליונים$(ts:\2)$2
(\d{1,3})(\d{15}) $(m:$1) קוואדראליון$(ts:\2)$2

1(\d{18}) קווינטיליון$(ts:\1)$1
2(\d{18}) שני קווינטיליונים$(ts:\1)$1
([3-9]|10)(\d{18}) $(m:$1) קווינטיליונים$(ts:\2)$2
(\d{1,3})(\d{18}) $(m:$1) קווינטיליון$(ts:\2)$2

1(\d{21}) סקסטיליון$(ts:\1)$1
2(\d{21}) שני סקסטיליונים$(ts:\1)$1
([3-9]|10)(\d{21}) $(m:$1) סקסטיליונים$(ts:\2)$2
(\d{1,3})(\d{21}) $(m:$1) סקסטיליון$(ts:\2)$2

1(\d{24}) ספטיליון$(ts:\1)$1
2(\d{24}) שני ספטיליונים$(ts:\1)$1
([3-9]|10)(\d{24}) $(m:$1) ספטיליונים$(ts:\2)$2
(\d{1,3})(\d{24}) $(m:$1) ספטיליון$(ts:\2)$2


# negative number

[-−](\d+) מינוס |$1

# decimals

"([-−]?\d+)[.,]" $1| נקודה
"([-−]?\d+[.,])([1-9]\d)" $1| |$2
"([-−]?\d+[.,])(\d)(\d)(\d)" $1| |$2 |$3 |$4
"([-−]?\d+[.,]\d*)(\d)" $1| |$2

# feminine->masculine correction, as all numbers are given for feminine gender

m:(.*)אחת \1אחד
m:(.*)שתיים \1שניים
m:(.*)חמש \1חמישה
m:(.*)שש \1שישה
m:(.*)(שלוש|ארבע|שבע|תשע|עשר) \1\2ה

m:(.*)אחת-עשרה \1אחד-עשר
m:(.*)שתים-עשרה \1שנים-עשר
m:(.*)חמש-עשרה \1חמישה-עשר
m:(.*)שש-עשרה \1שישה-עשר
m:(.*)(שלוש|ארבע|שבע|תשע)-עשרה \1\2ה-עשר

[fm]:(.*) \1

# numbers dependent on what they count

df:(.*)2 $1שתי

dm:1 אחד
dm:2 שני

# more rarely used
dm2:8 שמונת
dm2:(\d|10) $1ת
dm2:(.*) $(dm:\1)

d([fm]):(1(0{24}|0{21}|0{18}|0{15}|0{12}|0{9}|0{6}|0{3})) $(m:$2)
d([fm]):20{24} שני ספטיליוני
d([fm]):(\d{1,3})0{24} $(m:$2) ספטיליוני
d([fm]):20{21} שני סקסטיליוני
d([fm]):(\d{1,3})0{21} $(m:$2) סקסטיליוני
d([fm]):20{18} שני קווינטיליוני
d([fm]):(\d{1,3})0{18} $(m:$2) קווינטיליוני
d([fm]):20{15} שני קוודראליוני
d([fm]):(\d{1,3})0{15} $(m:$2) קוודראליוני
d([fm]):20{12} שני טריליוני
d([fm]):(\d{1,3})0{12} $(m:$2) טריליוני
d([fm]):20{9} שני מיליארדי
d([fm]):(\d{1,3})0{9} $(m:$2) מיליארדי
d([fm]):20{6} שני מיליוני
d([fm]):(\d{1,3})0{6} $(m:$2) מיליוני
d([fm]):20{3} אלפיים
d([fm]):(\d{1,3})0{3} $(dm2:\2) אלפים
d([fm]):(.*) $(\1:$2)

# numbers independent on what they count

i([fm]):(.*)[.,](.*) $(\1:$2) נקודה
i([fm]):(.*) $(\1:$2)


# currency

# gender unit, gender subunit, unit singular, unit, plural, subunit singular, subunit, plural

us(.).:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \2 $(\1:\6)
up(.).:([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) $(\1:\6) \3
ss.(.):([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) \4 $(\1:\6)
sp.(.):([^,]*),([^,]*),([^,]*),([^,]*),([^,]*) $(\1:\6) \5

# "mm" means masculine unit and masculine subunit

CHF:(.+),(.+) $(\1mm:פרנק שוויצרי,פרנקים שוויצריים,סנט,סנטים,\2)
CNY:(.+),(.+) $(\1mm:יואן,יואנים,פן,פנים,\2)
EUR:(.+),(.+) $(\1mm:אירו,אירו,סנט,סנטים,\2)
GBP:(.+),(.+) $(\1fm:לירה סטרלינג,לירות סטרלינג,פני,פנים,\2)
ILS:(.+),(.+) $(\1mf:שקל,שקלים,אגורה,אגורות,\2)
JPY:(.+),(.+) $(\1mm:יין,יינים,סן,סנים,\2)
USD:(.+),(.+) $(\1mm:דולר ארה"ב,דולרים ארה"ב,סנט,סנטים,\2)

"([A-Z]{3}) ([-−]?1)([.,]00?)?" $(\1:us,|$(dm:\2))
"([A-Z]{3}) ([-−]?\d+)([.,]00?)?" $(\1:up,|$(dm:\2))

"(CNY [-−]?\d+)[.,]10?" $1| ז'יאו אחד
"(CNY [-−]?\d+)[.,](\d)0?" $1| $2| ז'יאו
"(CNY [-−]?\d+[.,]\d)1" $1| $2| פן
"(CNY [-−]?\d+[.,]\d)(\d)" $1| $2| פן

"(([A-Z]{3}) [-−]?\d+)[.,](01)" $1| ו$(\2:ss,$(1))
"(([A-Z]{3}) [-−]?\d+)[.,](\d)" $1| ו$(\2:sp,$(\30))
"(([A-Z]{3}) [-−]?\d+)[.,](\d\d)" $1| ו$(\2:sp,$3)

# ordinal numbers: in hebrew, they depend on gender

# transform a number to a feminine ordinal

"ordm (\d+)" $(ordm:\1)

ordm:1 ראשון
ordm:2 שני
ordm:3 שלישי
ordm:4 רביעי
ordm:5 חמישי
ordm:6 שישי
ordm:7 שביעי
ordm:8 שמיני
ordm:9 תשיעי
ordm:10 עשירי

# transform a number to a masculine ordinal

"ordf (\d+)" $(ordf:\1)

ordf:1 ראשונה
ordf:2 שניה
ordf:([3-9]|10) $(ordm:\1)ת

# other numbers
ord([fm]):(\d+) $(\1:$2)

# from the end ;)
"ord([fm]) [-−](\d+)" $(ord\1:\2) מהסוף

# ordinal abbreviation: no such thing
"ord2([fm]) ([-−]\d+)" $(ord\1 \2)

# masculine assumption
"ord ([-−]?\d+)" $(ordm \1)

help פונקציות נוספות:\nord, ordm \(מספר סידורי זכר, כגון "ראשון"\)\nordf \(מספר סידורי נקבה, כגון "ראשונה"\)
"""
from __future__ import unicode_literals
